CREATE TABLE records (
  id           BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  
  -- Tipo de registro: tarea, recordatorio, contexto o config
  category     ENUM('task','reminder','context','config') NOT NULL,
  
  -- Nombre corto / título / clave
  label        VARCHAR(255) NULL,
  
  -- Estado genérico: pending, done, cancelled, active, inactive, etc.
  status       VARCHAR(32) NULL,
  
  -- Fecha relevante para ejecución / vencimiento
  run_at       DATETIME NULL,
  
  -- Fecha de expiración opcional
  expires_at   DATETIME NULL,
  
  -- Payload flexible
  meta         JSON NOT NULL,
  
  -- Auditoría básica
  created_at   TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at   TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  deleted_at   TIMESTAMP NULL DEFAULT NULL,
  
  PRIMARY KEY (id),
  KEY idx_records_cat_status (category, status),
  KEY idx_records_cat_runat  (category, run_at)
) ENGINE=InnoDB
  DEFAULT CHARSET=utf8mb4
  COLLATE=utf8mb4_spanish_ci;



CREATE TABLE voice_commands (
  id           BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  
  -- Frase que el usuario dice
  phrase       VARCHAR(255) NOT NULL,
  
  -- Identificador lógico de la acción
  intent       VARCHAR(64) NOT NULL,
  
  -- Parámetros por defecto para este comando
  params       JSON NOT NULL,
  
  -- Si viene de sistema o creado por usuario
  is_system    TINYINT(1) NOT NULL DEFAULT 1,
  
  -- Habilitado / deshabilitado
  is_enabled   TINYINT(1) NOT NULL DEFAULT 1,
  
  created_at   TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at   TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  
  PRIMARY KEY (id),
  KEY idx_voice_phrase (phrase),
  KEY idx_voice_intent (intent)
) ENGINE=InnoDB
  DEFAULT CHARSET=utf8mb4
  COLLATE=utf8mb4_spanish_ci;


INSERT INTO voice_commands (phrase, intent, params, is_system, is_enabled) VALUES
-- ===== TAREAS =====
('crear tarea', 'create_task', JSON_OBJECT(
  'category', 'task',
  'operation', 'create',
  'defaults', JSON_OBJECT(
    'status', 'pending'
  )
), 1, 1),

('nueva tarea', 'create_task', JSON_OBJECT(
  'category', 'task',
  'operation', 'create',
  'defaults', JSON_OBJECT(
    'status', 'pending'
  )
), 1, 1),

('ver tareas', 'list_tasks', JSON_OBJECT(
  'category', 'task',
  'operation', 'list',
  'filters', JSON_OBJECT(
    'status', JSON_ARRAY('pending')
  ),
  'order_by', 'run_at'
), 1, 1),

('tareas pendientes', 'list_tasks', JSON_OBJECT(
  'category', 'task',
  'operation', 'list',
  'filters', JSON_OBJECT(
    'status', JSON_ARRAY('pending')
  ),
  'order_by', 'run_at'
), 1, 1),

('marcar tarea como terminada', 'complete_task', JSON_OBJECT(
  'category', 'task',
  'operation', 'update',
  'set', JSON_OBJECT(
    'status', 'done'
  ),
  'match_strategy', 'by_label_or_context'  -- el agente decide cómo identificarla
), 1, 1),

('borrar tarea', 'delete_task', JSON_OBJECT(
  'category', 'task',
  'operation', 'soft_delete',
  'match_strategy', 'by_label_or_context'
), 1, 1),

-- ===== RECORDATORIOS =====
('crear recordatorio', 'create_reminder', JSON_OBJECT(
  'category', 'reminder',
  'operation', 'create',
  'defaults', JSON_OBJECT(
    'status', 'scheduled'
  )
), 1, 1),

('nuevo recordatorio', 'create_reminder', JSON_OBJECT(
  'category', 'reminder',
  'operation', 'create',
  'defaults', JSON_OBJECT(
    'status', 'scheduled'
  )
), 1, 1),

('ver recordatorios', 'list_reminders', JSON_OBJECT(
  'category', 'reminder',
  'operation', 'list',
  'filters', JSON_OBJECT(
    'status', JSON_ARRAY('scheduled')
  ),
  'order_by', 'run_at'
), 1, 1),

('recordatorios próximos', 'list_reminders', JSON_OBJECT(
  'category', 'reminder',
  'operation', 'list',
  'filters', JSON_OBJECT(
    'status', JSON_ARRAY('scheduled')
  ),
  'order_by', 'run_at',
  'limit_hours', 48
), 1, 1),

('cancelar recordatorio', 'cancel_reminder', JSON_OBJECT(
  'category', 'reminder',
  'operation', 'update',
  'set', JSON_OBJECT(
    'status', 'cancelled'
  ),
  'match_strategy', 'by_label_or_time'
), 1, 1),

('reprogramar recordatorio', 'reschedule_reminder', JSON_OBJECT(
  'category', 'reminder',
  'operation', 'update',
  'set', JSON_OBJECT(
    'status', 'scheduled'
  ),
  'match_strategy', 'by_label_or_time',
  'allow_new_run_at', TRUE
), 1, 1),

-- ===== CONTEXTOS =====
('guardar contexto', 'save_context', JSON_OBJECT(
  'category', 'context',
  'operation', 'create_or_update',
  'match_strategy', 'by_label',
  'set_last_used', TRUE
), 1, 1),

('cambiar de contexto', 'switch_context', JSON_OBJECT(
  'category', 'context',
  'operation', 'activate',
  'config_link', JSON_OBJECT(
    'config_label', 'active_context'   -- se guarda en records.category=config
  )
), 1, 1),

('ver contextos', 'list_contexts', JSON_OBJECT(
  'category', 'context',
  'operation', 'list',
  'filters', JSON_OBJECT(
    'status', JSON_ARRAY('active','inactive')
  )
), 1, 1),

('desactivar contexto', 'deactivate_context', JSON_OBJECT(
  'category', 'context',
  'operation', 'update',
  'set', JSON_OBJECT(
    'status', 'inactive'
  ),
  'match_strategy', 'by_label'
), 1, 1),

-- ===== CONFIGURACIÓN =====
('configuración del asistente', 'show_config', JSON_OBJECT(
  'category', 'config',
  'operation', 'list'
), 1, 1),

('cambiar configuración', 'update_config', JSON_OBJECT(
  'category', 'config',
  'operation', 'upsert'
), 1, 1),

('mostrar comandos disponibles', 'list_voice_commands', JSON_OBJECT(
  'operation', 'list_voice_commands',
  'filters', JSON_OBJECT(
    'is_enabled', TRUE
  )
), 1, 1),

('ayuda', 'help', JSON_OBJECT(
  'operation', 'show_help',
  'include', JSON_ARRAY('examples','basic_commands')
), 1, 1);
